﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using System.Web.UI;
using System.Web.UI.WebControls;
using BMS.Utils;

namespace BMS.Web.Reporting
{
    public partial class ReportError : System.Web.UI.Page
    {
        protected void Page_Load(object sender, EventArgs e)
        {
            DateTime entryInLogMethodTime = DateTime.UtcNow;
            if (InfoWorld.Tracing.IWTrace.IsEntryEnabled)
            {
                InfoWorld.Tracing.IWTrace.Entry(System.Reflection.MethodBase.GetCurrentMethod(), entryInLogMethodTime);
            }
            try
            {
                if (Session[Constants.REPORTS_ERROR_MESSAGE_SESSION_KEY] != null)
                {
                    lblErrorMessage.Text = Session[Constants.REPORTS_ERROR_MESSAGE_SESSION_KEY].ToString();
                    Session[Constants.REPORTS_ERROR_MESSAGE_SESSION_KEY] = null;
                }

            }
            finally
            {
                if (InfoWorld.Tracing.IWTrace.IsExitEnabled)
                {
                    InfoWorld.Tracing.IWTrace.Exit(System.Reflection.MethodBase.GetCurrentMethod(), DateTime.UtcNow, entryInLogMethodTime);
                }
            }
        }
    }
}